﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{
    public class HappyHourPromoDB
    {
        public static HappyHours GetItem(Guid PromoID)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@PromoID", ((PromoID != Guid.Empty && PromoID != null) ? PromoID : (object)DBNull.Value)));


            return SQLHelper.RetrieveObject<HappyHours>("spGetHappyHourPromos", parameters);
        }

        public static List<HappyHours> GetList(Guid PromoID)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@PromoID", ((PromoID != Guid.Empty && PromoID != null) ? PromoID : (object)DBNull.Value)));

            return SQLHelper.RetrieveList<HappyHours>("spGetHappyHourPromos", parameters);
        }

        public static void Save(HappyHours Promo)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            if (Promo.UniqueID == Guid.Empty)
            {
                Promo.UniqueID = Guid.NewGuid();
                Promo.IsEnabled = true;
            }

            parameters.Add(new SqlParameter("@PromoID", (Promo.UniqueID != null && Promo.UniqueID != Guid.Empty) ? Promo.UniqueID : (object)DBNull.Value));
            parameters.Add(new SqlParameter("@PromoName", ((Promo.PromoName != null && !string.IsNullOrEmpty(Promo.PromoName)) ? Promo.PromoName : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@StartTime", ((Promo.StartTime != null && Promo.StartTime != DateTime.MinValue) ? Promo.StartTime : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@EndTime", ((Promo.EndTime != null && Promo.EndTime != DateTime.MinValue) ? Promo.EndTime : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@IsEnabled", Promo.IsEnabled));
            parameters.Add(new SqlParameter("@DisplayStartTime", ((Promo.DisplayStartTime != null && !string.IsNullOrEmpty(Promo.DisplayStartTime)) ? Promo.DisplayStartTime : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@DisplayEndTime", ((Promo.DisplayEndTime != null && !string.IsNullOrEmpty(Promo.DisplayEndTime)) ? Promo.DisplayEndTime : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@CreatedBy", (Promo.CreatedBy != null && Promo.CreatedBy != Guid.Empty) ? Promo.CreatedBy : (object)DBNull.Value));

            SQLHelper.ExecuteQuery("spAddOrUpdateHappyHourPromo", parameters);
        }

        public static void Delete(Guid TableID)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@PromoID", ((TableID != Guid.Empty && TableID != null) ? TableID : (object)DBNull.Value)));

            SQLHelper.ExecuteQuery("spRemoveHappyHourPromos", parameters);
        }
    }
}
